<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Cart extends Model 
{

    protected $table = 'carts';
    public $timestamps = true;
    protected $fillable = array('product_id', 'quantity', 'note', 'order_id');

    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

    public function additions()
    {
        return $this->belongsToMany('App\Models\Addition', 'addition_id');
    }

    public function order()
    {
        return $this->belongsTo('App\Models\Order', 'order_id');
    }

}